#pragma once

#include "features.h"

#include <drive/library/cpp/taxi/surge_calculator/client.h>
#include <drive/library/cpp/rtmr/client.h>
#include <util/datetime/base.h>

class TGeoCoord;
class TWeatherInfo;

namespace NDrive {
    class IServer;
}

namespace NDrive {
    struct TGeoFeatures;
    struct TUserFeatures;
    struct TUserGeoFeatures;
    struct TUserDoubleGeoFeatures;

    void CalcDeviceFeatures(TOfferFeatures& features, const NDrive::IServer& server, const TString& deviceId);

    void CalcGeoFeatures(TOfferFeatures& features, const TGeoFeatures* geoFeatures);
    void CalcGeoFeatures(TOfferFeatures& features, ui64 geobaseId, const TGeoFeatures* geobaseFeatures);

    void CalcSourceFeatures(TOfferFeatures& features, const TUserGeoFeatures* userGeoFeatures);
    void CalcSourceFeatures(TOfferFeatures& features, ui64 geobaseId, const TUserGeoFeatures* userGeobaseFeatures);

    void CalcDestinationFeatures(TOfferFeatures& features, const TGeoCoord& coordinate, const TGeoFeatures* geoFeatures, const TUserGeoFeatures* userGeoFeatures, double distance, double duration);
    void CalcDestinationFeatures(TOfferFeatures& features, ui64 geobaseId, const TGeoFeatures* geobaseFeatures, const TUserGeoFeatures* userGeobaseFeatures);
    void CalcDestinationFeatures(TOfferFeatures& features, const TUserDoubleGeoFeatures* userDoubleGeoFeatures);
    void CalcDestinationFeatures(TOfferFeatures& features, ui64 geobaseId, const TUserDoubleGeoFeatures* userDoubleGeobaseFeatures);

    void CalcBestDestinationFeatures(TOfferFeatures& features, double score);
    void CalcRequestFeatures(TOfferFeatures& features, TInstant timestamp);
    void CalcPriceFeatures(TOfferFeatures& features, float price, float equilibrium);
    void CalcWaitingPriceFeatures(TOfferFeatures& features, float price, float equilibrium);
    void CalcWeatherFeatures(TOfferFeatures& features, const TWeatherInfo& info);
    void CalcUserFeatures(
        TOfferFeatures& features,
        const TString& userId,
        const TUserFeatures& userFeatures
    );
    void CalcUserFeatures(TOfferFeatures& features, const TGeoCoord& coordinate);
    void CalcUserFeatures(TOfferFeatures& features, TDuration walkingDuration);

    void CalcOfferNameFeatures(TOfferFeatures& features, const TString& name, const TString& groupName);
    void CalcOfferPackPriceFeatures(TOfferFeatures& features, ui32 price, ui32 publicDiscountedPrice);
    void CalcOfferOverrunPriceFeatures(TOfferFeatures& features, ui32 price);
    void CalcOfferDurationFeatures(TOfferFeatures& features, TDuration duration);
    void CalcOfferRouteDurationFeatures(TOfferFeatures& features, TDuration duration);
    void CalcOfferMileageLimitFeatures(TOfferFeatures& features, float limit);
    void CalcOfferAcceptancePriceFeatures(TOfferFeatures& features, ui32 price);
    void CalcOfferDepositAmountFeatures(TOfferFeatures& features, ui32 price);
    // CalcModelResultFeatures updates features for previous model results.
    void CalcModelResultFeatures(TOfferFeatures& features, double result);
    void CalcOfferTaxiSurgeFeatures(
        TOfferFeatures& features,
        const NDrive::TTaxiSurgeCalculator::TResult& result
    );
    void CalcOfferTaxiCarSurgeFeatures(
        TOfferFeatures& features,
        const NDrive::TTaxiSurgeCalculator::TResult& result
    );
    void CalcOfferCashbackPercentFeatures(TOfferFeatures& features, ui32 percent);
    void CalcOfferIsPlusUserFeatures(TOfferFeatures& features, bool plus);
    void CalcOfferFixPointAcceptancePriceFeatures(TOfferFeatures& features, const TMaybe<ui32>& price);
    void CalcOfferInsurancePriceFeatures(TOfferFeatures& features, const TMaybe<ui32>& price);
    void CalcOfferInsurancePackPriceFeatures(TOfferFeatures& features, const TMaybe<ui32>& price);
    void CalcOfferRtmrSurgeAreaId(TOfferFeatures& features, const TString& surgeAreaId);
    void CalcOfferRtmrAreaSurge(TOfferFeatures& features, const NDrive::TRtmrSurge& surge);
    void CalcOfferRtmrAreaExtendedSurge(TOfferFeatures& features, const NDrive::TRtmrExtendedSurge& surge);
    void CalcOfferAggressionScoring(TOfferFeatures& features, double value);
    void CalcUserLastPricedRideTime(TOfferFeatures& features, TInstant time);
    void CalcFinishAreaId(TOfferFeatures& features, TString id = "");
}
