#include "features.h"

#include <drive/library/cpp/user_events_api/user_features.h>
#include <rtline/library/json/cast.h>

#include <util/random/random.h>

NDrive::TOfferFeatures::TOfferFeatures() {
    Floats.fill(0);
    Floats2.fill(UserFeaturesDefaultValue);
    Categories2.fill({});
}

TConstArrayRef<float> NDrive::TOfferFeatures::FloatsView() const {
    return { Floats.begin(), Floats.end() };
}

TVector<TStringBuf> NDrive::TOfferFeatures::CategoriesView2() const {
    return { Categories2.begin(), Categories2.end() };
}

TConstArrayRef<float> NDrive::TOfferFeatures::FloatsView2() const {
    return { Floats2.begin(), Floats2.end() };
}

void NDrive::TOfferFeatures::StoreDebugInfo(const TString& modelName, const TVector<double>& scores) const {
    if (!ModelsDebugInfo.contains(modelName)) {
        ModelsDebugInfo[modelName] = scores;
    }
}

float NDrive::TOfferFeatures::GetPrice() const {
    auto current = Floats[NDriveOfferFactors::FI_MODEL_PRICE];
    auto original = Floats[NDriveOfferFactors::FI_PRICE];
    if (current > 0) {
        return current;
    } else {
        return original;
    }
}

template <>
NJson::TJsonValue NJson::ToJson<NDrive::TOfferFeatures>(const NDrive::TOfferFeatures& value) {
    return NJson::ToJson(std::tie(
        value.Floats, value.Categories2, value.Floats2
    ));
}

template <>
bool NJson::TryFromJson<NDrive::TOfferFeatures>(const NJson::TJsonValue& value, NDrive::TOfferFeatures& result) {
    if (!value.IsArray()) {
        return false;
    }
    const auto& a = value.GetArray();
    if (a.size() < 2) {
        return false;
    }

    const NJson::TJsonValue& floats = a[0];
    if (!floats.IsArray()) {
        return false;
    }
    for (size_t i = 0; i < floats.GetArray().size(); ++i) {
        const NJson::TJsonValue& element = floats.GetArray()[i];
        if (!element.IsDouble()) {
            return false;
        }
        result.Floats[i] = element.GetDouble();
    }

    const NJson::TJsonValue& categories = a[1];
    if (!categories.IsArray()) {
        return false;
    }
    for (size_t i = 0; i < categories.GetArray().size(); ++i) {
        const NJson::TJsonValue& element = categories.GetArray()[i];
        if (!element.IsString()) {
            return false;
        }
        result.Categories2[i] = element.GetString();
    }
    if (a.size() > 2) {
        const NJson::TJsonValue& floats2 = a[2];
        if (!floats2.IsArray()) {
            return false;
        }
        for (size_t i = 0; i < std::min(result.Floats2.size(), floats2.GetArray().size()); ++i) {
            const NJson::TJsonValue& element = floats2.GetArray()[i];
            if (!element.IsDouble()) {
                return false;
            }
            result.Floats2[i] = element.GetDouble();
        }
    }
    return true;
}
