#pragma once

#include <drive/backend/offers/factors/factors_info.h>

#include <util/generic/vector.h>

#include <array>

namespace NDrive {
    struct TOfferFeatures {
    private:
        mutable TMap<TString, TVector<double>> ModelsDebugInfo;
    public:
        std::array<float, NDriveOfferFactors::FI_FACTOR_COUNT> Floats;
        std::array<float, NDriveOfferFactors2::FI_FACTOR_COUNT> Floats2;
        std::array<TString, NDriveOfferCatFactors2::FI_FACTOR_COUNT> Categories2;

        TOfferFeatures();

        TConstArrayRef<float> FloatsView() const;

        TVector<TStringBuf> CategoriesView2() const;
        TConstArrayRef<float> FloatsView2() const;

        TMap<TString, TVector<double>>& GetModelsDebugInfo() const {
            return ModelsDebugInfo;
        }

        void StoreDebugInfo(const TString& modelName, const TVector<double>& scores) const;

        float GetPrice() const;
    };
}
