#pragma once
#include "parking_info.h"

#include <drive/library/cpp/parking/api/client.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/expected.h>

class IReplyContext;
namespace NDrive {
    class IServer;
}
namespace NRTLine {
    class TNehSearchClient;
}

namespace NDrive {
    class TParkingZonesManagerConfig {
        R_READONLY(TString, RTLineAPIName);
        R_READONLY(TParkingConfig, ParkingConfig);

    public:
        double GetMaxPrecision() const {
            return ParkingConfig.GetMaxPrecision();
        }

        void Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
    };

    class TParkingZonesManager {
    private:
        const NDrive::IServer& Server;
        const TParkingZonesManagerConfig& Config;
        const NRTLine::TNehSearchClient& SearchClient;

    public:
        TParkingZonesManager(const TParkingZonesManagerConfig& config, const NDrive::IServer& server);

        TExpected<TParkingInfo, TString> IsParkingAllowed(const TGeoCoord& c, TMaybe<double> precisionValue = {}) const;
        TExpected<TParkingInfo, TString> IsParkingAllowed(const TString& userId, const IReplyContext& context, TMaybe<double> precisionValue = {}) const;
    };

    class TParkingAggregatorsManagerConfig {
    public:
        void Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        const TMskParkingPaymentConfig* GetAmppConfig() const;

    private:
        R_READONLY(TString, KznClientToken);
        R_READONLY(TString, SpbClientToken);
        R_READONLY(TString, MskClientToken);
        THolder<TMskParkingPaymentConfig> AmppConfig;
    };

    class TParkingAggregatorsManager {
    public:
        struct TSlot {
            TString Token;
            TString ParkingVehicleId;
            TString ParkingSessionId;
            NJson::TJsonValue Session;
            NJson::TJsonValue Refund;
            double Cost = 0;
            i64 SessionAggregatorId = 0;
            TInstant SessionFinish;

            bool IsActive(TInstant now) const;
            NJson::TJsonValue ToJson() const;
        };

    public:
        TParkingAggregatorsManager(const TParkingAggregatorsManagerConfig& config);
        void StopParking(const TString& carId, const TString& userId, const TString& carNumber, TSlot& slot) const;

    private:
        NJson::TJsonValue StopClient3Parking(const TSlot& slot) const;
        NJson::TJsonValue StopClient3Parking(const TString& carId, const TString& userId, const TString& token, const TString& sessionId, const TString& vehicleId) const;
        NJson::TJsonValue StopFitParking(const i64 aggregatorId, const TString& sessionId) const;
        NDrive::TMskParkingPaymentClient::TSession StopAmppParking(const TString& carNumber) const;

    private:
        const TParkingAggregatorsManagerConfig& Config;
        THolder<NDrive::TFitDevParkingPaymentClient> KznClient;
        THolder<NDrive::TSpbParkingPaymentClient> SpbClient;
        THolder<NDrive::TMosParkingPaymentClient> MskClient;
        THolder<NDrive::TMskParkingPaymentClient> AmppClient;
    };

}  // namespace NDrive
