#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/api/search_client/query.h>
#include <rtline/library/graph/traffic_graph/geo_objects/parking/parking.h>
#include <rtline/protos/proto_helper.h>

class TGeoCoord;
class TMessagesCollector;

enum class EParkingDenyDetails {
    NoDetails,
    Parking,
    ClosedZone
};

enum class EParkingAbility {
    Undefined,
    Allow,
    Deny
};

class TParkingConfig {
private:
    double DistanceAcceptParkingAllow = 30;
    double DistanceAcceptParkingDeny = 30;
    double BorderRelationStopsAllow = 0.1;
    double BorderRelationStopsDeny = 0.7;
    double FinalAllowAcceptanceLength = 30;
    double FinalDenyAcceptanceLength = 30;

public:
    double GetFinalAllowAcceptanceLength() const {
        return FinalAllowAcceptanceLength;
    }

    double GetFinalDenyAcceptanceLength() const {
        return FinalDenyAcceptanceLength;
    }

    double GetMaxPrecision() const {
        return Max(DistanceAcceptParkingAllow, DistanceAcceptParkingDeny);
    }

    bool CheckParkingAbility(const TParking::EParkingType type, const double distance, EParkingAbility& result) const;
    bool CheckParkingAbility(const ui32 constraintsStop, const ui32 passInStop, const ui32 passOutStop, EParkingAbility& result) const;

    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};

class TParkingInfo {
public:
    bool SignalIssues = false;
    EParkingAbility Ability = EParkingAbility::Undefined;
    EParkingDenyDetails DenyDetails = EParkingDenyDetails::NoDetails;
    TSet<TString> Tags;

    static NRTLine::TQuery CreateQuery(const TGeoCoord& c, double precision);
    bool Parse(const NMetaProtocol::TReport& report, const TParkingConfig& config, const double precision, TMessagesCollector& errors);
};
