#pragma once

#include <library/cpp/object_factory/object_factory.h>
#include <drive/backend/compiled_riding/compiled_riding.h>
#include <drive/backend/users/user.h>


namespace NDrive::NPartners {

    enum class EAggregator {
        Jeep = 1,
    };

    class ILeadsSender {
    public:
        using TPtr = TAtomicSharedPtr<ILeadsSender>;
        using TFactory = NObjectFactory::TObjectFactory<ILeadsSender, EAggregator>;
        using TRiding = TObjectEvent<TMinimalCompiledRiding>;

    public:
        virtual ~ILeadsSender() = default;
        virtual bool Init(const TString& config) = 0;
        virtual TDuration GetRequestTimeout() const = 0;
        virtual NThreading::TFuture<void> SendLead(const TDriveUserData& user, const TRiding& riding) const = 0;

        static TPtr GetPartnerClient(const EAggregator type);
    };


}
