#include "jeep.h"


namespace {

    using TExtFieldType = NDrive::TJeepRequestData::TRequestExtraField::EExtraFieldName;

}


namespace NDrive::NPartners {

    bool TJeepClient::Init(const TString& config) {
        auto conf = NDrive::TJeepApiConfig::ParseFromString(config);
        if (!conf) {
            return false;
        }
        Client = MakeHolder<NDrive::TJeepClient>(*conf);
        return true;
    }

    TDuration TJeepClient::GetRequestTimeout() const {
        return Client ? Client->GetConfig().GetRequestTimeout() : TDuration::Zero();
    }

    NThreading::TFuture<void> TJeepClient::SendLead(const TDriveUserData& user, const TRiding& ride) const {
        if (!Client) {
            return NThreading::TExceptionFuture() << "Client is not configured";
        }
        NDrive::TJeepRequestData data;
        data.MutablePersonalData().SetUserId(ride.GetHistoryUserId());
        data.MutablePersonalData().SetUserName(user.GetFirstName());
        data.MutablePersonalData().SetSurname(user.GetLastName());
        data.MutablePersonalData().SetEmail(user.GetEmail());
        data.MutablePersonalData().SetPhone(user.GetPhone());
        data.MutableRequestData().SetExternalRequestId(ride.GetSessionId());
        data.MutableRequestData().SetRequestDate(Now());
        data.MutableRequestExtraFields().emplace_back(TExtFieldType::RentStartDate, ride.GetStartInstant().Get().ToStringLocalUpToSeconds());
        data.MutableRequestExtraFields().emplace_back(TExtFieldType::RentEndDate, ride.GetFinishInstant().Get().ToStringLocalUpToSeconds());
        return Client->SendLead(data);
    }
}
