#pragma once

#include "common.h"

#include <drive/library/cpp/jeep/client.h>

namespace NDrive::NPartners {

    class TJeepClient : public ILeadsSender {
    public:
        virtual bool Init(const TString& config) override;
        virtual TDuration GetRequestTimeout() const override;
        virtual NThreading::TFuture<void> SendLead(const TDriveUserData& user, const TRiding& riding) const override;

    private:
        THolder<NDrive::TJeepClient> Client;
        static inline ILeadsSender::TFactory::TRegistrator<TJeepClient> Registrator{EAggregator::Jeep};
    };

}
