#include <drive/backend/processor/versioned.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/logger/global/global.h>

Y_UNIT_TEST_SUITE(VersionedKey) {

    Y_UNIT_TEST(TestParse) {
        TVersionedKey vk1("blabla");
        CHECK_WITH_LOG(vk1.GetName() == "blabla");
        CHECK_WITH_LOG(vk1.GetVersion() == TVersionInfo()) << ": version " << vk1.GetVersion().ToString() << " != " << TVersionInfo().ToString() << Endl;

        TVersionedKey vk2("v1/blabla");
        CHECK_WITH_LOG(vk2.GetName() == "blabla");
        TVersionInfo v2(1, TVersionInfo::Undef, TVersionInfo::Undef);
        CHECK_WITH_LOG(vk2.GetVersion() == v2) << ": version " << vk2.GetVersion().ToString() << " != " << v2.ToString() << Endl;

        TVersionedKey vk3("v1.2/blabla");
        CHECK_WITH_LOG(vk3.GetName() == "blabla");
        TVersionInfo v3(1, 2, TVersionInfo::Undef);
        CHECK_WITH_LOG(vk3.GetVersion() == v3) << ": version " << vk3.GetVersion().ToString() << " != " << v3.ToString() << Endl;

        TVersionedKey vk4("v1.2.4/blabla");
        CHECK_WITH_LOG(vk4.GetName() == "blabla");
        TVersionInfo v4(1, 2, 4);
        CHECK_WITH_LOG(vk4.GetVersion() == v4) << ": version " << vk4.GetVersion().ToString() << " != " << v4.ToString() << Endl;
    }

    Y_UNIT_TEST(TestCompare) {
        TVersionedKey vk1("bla1");
        TVersionedKey vk11("v1/bla1");
        TVersionedKey vk112("v1.2/bla1");
        TVersionedKey vk1120("v1.2.0/bla1");
        TVersionedKey vk1124("v1.2.4/bla1");
        TVersionedKey vk2("bla2");
        CHECK_WITH_LOG(vk1120 < vk1124);
        CHECK_WITH_LOG(vk1124 < vk112);
        CHECK_WITH_LOG(vk112 < vk11);
        CHECK_WITH_LOG(vk11 < vk1);
        CHECK_WITH_LOG(vk1 < vk2);
    }

    Y_UNIT_TEST(TestMatch) {
        TVersionedKey vk1("bla1");
        TVersionedKey vk11("v1/bla1");
        TVersionedKey vk112("v1.2/bla1");
        TVersionedKey vk1120("v1.2.0/bla1");
        TVersionedKey vk1124("v1.2.4/bla1");
        TVersionedKey vk2("bla2");

        CHECK_WITH_LOG(vk11.Match(vk1));
        CHECK_WITH_LOG(!vk1.Match(vk11));

        CHECK_WITH_LOG(vk112.Match(vk11));
        CHECK_WITH_LOG(!vk11.Match(vk112));

        CHECK_WITH_LOG(vk1120.Match(vk112));
        CHECK_WITH_LOG(!vk112.Match(vk1120));

        CHECK_WITH_LOG(!vk1120.Match(vk1124));
        CHECK_WITH_LOG(!vk1124.Match(vk1120));

    }

}


