#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/db_entities.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/areas/areas.h>

template <class T>
class TAreaReportCommonProcessor: public TAppCommonProcessor<T> {
private:
    using TBase = TAppCommonProcessor<T>;

public:
    using TBase::TBase;

    NJson::TJsonValue GetLocalized(NJson::TJsonValue&& value) const;
    NJson::TJsonValue GetLocalizedJsonSetting(TStringBuf key) const;
    NJson::TJsonValue GetLocalizedJsonSetting(TConstArrayRef<TString> keys) const;
    NJson::TJsonValue GetLocalizedJsonSetting(TConstArrayRef<TString> pathes, const TString& key, TString* resultPath = nullptr) const;
    NJson::TJsonValue GetLocalizedStyleReport(TAreasDB::EAreaStyle style, TStringBuf suffix, TString* resultPath = nullptr) const;
    NJson::TJsonValue GetLocalizedStyleLegendReport(TStringBuf suffix) const;
};

class TAreasHistoryProcessor: public TAppCommonProcessor<TAreasHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAreasHistoryProcessor, TEmptyConfig>;

public:
    TAreasHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "areas_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAreasInfoProcessor: public TAppCommonProcessor<TAreasInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAreasInfoProcessor, TEmptyConfig>;

public:
    TAreasInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "areas_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TParkingAreasInfoProcessor: public TAreaReportCommonProcessor<TParkingAreasInfoProcessor> {
private:
    using TBase = TAreaReportCommonProcessor<TParkingAreasInfoProcessor>;

public:
    TParkingAreasInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "parking_areas_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAreasUpsertProcessor: public TAppCommonProcessor<TAreasUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAreasUpsertProcessor, TEmptyConfig>;

public:
    TAreasUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "areas_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAreasRemoveProcessor: public TAppCommonProcessor<TAreasRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAreasRemoveProcessor, TEmptyConfig>;

public:
    TAreasRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "areas_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAreasOperationProcessor : public TAreaReportCommonProcessor<TAreasOperationProcessor> {
private:
    using TBase = TAreaReportCommonProcessor<TAreasOperationProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "areas_operation";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAreasProposeProcessor: public TObjectsProposeProcessor<TArea, TAreasProposeProcessor> {
private:
    using TBase = TObjectsProposeProcessor<TArea, TAreasProposeProcessor>;

protected:
    virtual const IDBEntitiesWithPropositionsManager<TArea>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetDriveAPI()->GetAreasDB();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Areas;
    }
public:
    using TBase::TBase;
};

class TAreasConfirmProcessor: public TObjectsConfirmProcessor<TArea, TAreasConfirmProcessor> {
private:
    using TBase = TObjectsConfirmProcessor<TArea, TAreasConfirmProcessor>;

protected:
    virtual const IDBEntitiesWithPropositionsManager<TArea>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetDriveAPI()->GetAreasDB();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Areas;
    }
public:
    using TBase::TBase;
};

class TAreasRejectPropositionProcessor: public TObjectsRejectProcessor<TArea, TAreasRejectPropositionProcessor> {
private:
    using TBase = TObjectsRejectProcessor<TArea, TAreasRejectPropositionProcessor>;

protected:
    virtual const IDBEntitiesWithPropositionsManager<TArea>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetDriveAPI()->GetAreasDB();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Areas;
    }
public:
    using TBase::TBase;
};
