#pragma once

#include <drive/backend/processors/accounts/processor.h>

template <class TProcessor>
class TCompiledEntityHistory: public TAccountsProcessorsBase<TProcessor> {
private:
    using TBase = TAccountsProcessorsBase<TProcessor>;

protected:
    using TBase::TBase;

    template <class T>
    void Process(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const T& manager);
};

class TCompiledBillsHistory: public TCompiledEntityHistory<TCompiledBillsHistory> {
private:
    using TBase = TCompiledEntityHistory<TCompiledBillsHistory>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "compiled_bills_history";
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCompiledRefundsHistory: public TCompiledEntityHistory<TCompiledRefundsHistory> {
private:
    using TBase = TCompiledEntityHistory<TCompiledRefundsHistory>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "compiled_refunds_history";
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
