#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

class TCarModelsInfoProcessor : public TAppCommonProcessor<TCarModelsInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelsInfoProcessor, TEmptyConfig>;
public:
    TCarModelsInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "car_models_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarModelsRemoveProcessor : public TAppCommonProcessor<TCarModelsRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelsRemoveProcessor, TEmptyConfig>;
public:
    TCarModelsRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "car_models_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarModelSpecificationAddProcessor : public TAppCommonProcessor<TCarModelSpecificationAddProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelSpecificationAddProcessor, TEmptyConfig>;
public:
    TCarModelSpecificationAddProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "car_model_specification_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarModelSpecificationRemoveProcessor : public TAppCommonProcessor<TCarModelSpecificationRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelSpecificationRemoveProcessor, TEmptyConfig>;
public:
    TCarModelSpecificationRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "car_model_specification_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
