#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

class TCarUpsertProcessor : public TAppCommonProcessor<TCarUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarUpsertProcessor, TEmptyConfig>;

public:
    TCarUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarVinValidationProcessor : public TAppCommonProcessor<TCarVinValidationProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarVinValidationProcessor, TEmptyConfig>;

public:
    TCarVinValidationProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_vin_validation";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarModificationsHistoryProcessor : public TAppCommonProcessor<TCarModificationsHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModificationsHistoryProcessor, TEmptyConfig>;

public:
    TCarModificationsHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_modification_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarAttachedHardwareProcessor : public TAppCommonProcessor<TCarAttachedHardwareProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarAttachedHardwareProcessor, TEmptyConfig>;

public:
    TCarAttachedHardwareProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_attached_hardware";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarAssignAttachmentProcessor : public TAppCommonProcessor<TCarAssignAttachmentProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarAssignAttachmentProcessor, TEmptyConfig>;

public:
    TCarAssignAttachmentProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_assign_attachment";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarAttachedHardwareHistoryProcessor : public TAppCommonProcessor<TCarAttachedHardwareHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarAttachedHardwareHistoryProcessor, TEmptyConfig>;

public:
    TCarAttachedHardwareHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_assignment_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarUnassignAttachmentProcessor : public TAppCommonProcessor<TCarUnassignAttachmentProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarUnassignAttachmentProcessor, TEmptyConfig>;

public:
    TCarUnassignAttachmentProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_unassign_attachment";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarRegistryUpdateProcessor : public TAppCommonProcessor<TCarRegistryUpdateProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarRegistryUpdateProcessor, TEmptyConfig>;

public:
    TCarRegistryUpdateProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_registry_update";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarModelsListProcessor : public TAppCommonProcessor<TCarModelsListProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelsListProcessor, TEmptyConfig>;

public:
    TCarModelsListProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_models_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCarInsuranceUploadProcessor : public TAppCommonProcessor<TCarInsuranceUploadProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarInsuranceUploadProcessor, TEmptyConfig>;

public:
    TCarInsuranceUploadProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_insurance_upload";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TOsagoUpdateProcessor : public TAppCommonProcessor<TOsagoUpdateProcessor, TTOsagoUpdateProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TOsagoUpdateProcessor, TTOsagoUpdateProcessorConfig>;

public:
    TOsagoUpdateProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "osago_update";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TFuelingCardsUploadProcessor : public TAppCommonProcessor<TFuelingCardsUploadProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TFuelingCardsUploadProcessor, TEmptyConfig>;

public:
    TFuelingCardsUploadProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "fueling_cards_upload";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
