#pragma once

#include "config.h"

#include <drive/backend/processors/car_scanner/proto/scanner.pb.h>

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/common/localization.h>
#include <drive/backend/tags/tag.h>

#include <rtline/library/geometry/coord.h>

class TStartScannerProcessor: public TAppCommonProcessor<TStartScannerProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStartScannerProcessor, TEmptyConfig>;
public:
    TStartScannerProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "start_scanner";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TStopScanner: public TAppCommonProcessor<TStopScanner, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStopScanner, TEmptyConfig>;
public:
    TStopScanner(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "stop_scanner";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAreaScanner: public TAppCommonProcessor<TAreaScanner, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAreaScanner, TEmptyConfig>;
public:
    TAreaScanner(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "areas_scanner";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
