#include "callback.h"

#include "processor.h"

#include <drive/backend/logging/logging.h>
#include <drive/backend/report/json.h>

void TChatResponseBaseJsonCallback::FinalizeWithJson(NJson::TJsonValue report, const HttpCodes httpCode) {
    if (!Report) {
        return;
    }

    NDrive::TEventLog::TUserIdGuard userIdGuard(UserId);
    TJsonReport::TGuard g(Report, httpCode);
    g.MutableReport().SetExternalReport(std::move(report));
    g.SetCode(httpCode);
}

void TChatMediaSimpleCallback::OnSuccess(const TString& resourceId) {
    NJson::TJsonValue report;
    report["status"] = "ok";
    report["resource_id"] = resourceId;
    FinalizeWithJson(report, HTTP_OK);
}

void TChatMediaSimpleCallback::OnFailure(const TString& errorMessage, const HttpCodes code) {
    NJson::TJsonValue report;
    report["status"] = "error";
    report["error"] = errorMessage;
    FinalizeWithJson(report, code);
}
