#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/abstract/base.h>
#include <drive/backend/chat_robots/abstract.h>
#include <drive/backend/logging/events.h>

#include <drive/library/cpp/taxi/chat/client.h>

class TChatResponseBaseJsonCallback {
public:
    TChatResponseBaseJsonCallback(IServerReportBuilder::TPtr report, const TString& userId)
        : Report(report)
        , UserId(userId)
    {
    }

protected:
    IServerReportBuilder::TPtr Report;
    TString UserId;

protected:
    virtual void FinalizeWithJson(NJson::TJsonValue report, const HttpCodes httpCode);
};

class TExternalMessageData {
    R_CONST(ITaxiChatClient*, TaxiChatClient);
    R_FIELD(TString, Message);
    R_FIELD(TString, ChatId);

public:
    TExternalMessageData(const ITaxiChatClient* taxiChatClient, const TString& message, const TString& chatId)
        : TaxiChatClient(taxiChatClient)
        , Message(message)
        , ChatId(chatId)
    {
    }
};

class TChatMediaSimpleCallback
    : public TChatResponseBaseJsonCallback
    , public IChatMediaResourcePostUploadCallback
{
private:
    using TBase = TChatResponseBaseJsonCallback;

public:
    using TBase::TBase;

    virtual void OnSuccess(const TString& resourceId) override;
    virtual void OnFailure(const TString& errorMessage, const HttpCodes code = HttpCodes::HTTP_INTERNAL_SERVER_ERROR) override;
};
