#pragma once

#include "callback.h"
#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/data/user_tags.h>
#include <drive/backend/support_center/manager.h>
#include <drive/backend/support_center/request_filter.h>

#include <drive/library/cpp/taxi/support_classifier/client.h>

namespace NChatOutputHelpers {
    void GetExpectedActionReport(NJson::TJsonValue& result, const IChatRobot::TPtr chatRobot, const TString& topic, const IChatUserContext::TPtr ctx);
    NJson::TJsonValue GetFaqUrl(const IChatRobot::TPtr chatRobot);
    NJson::TJsonValue GetSupportUrl(const IChatRobot::TPtr chatRobot);
    NJson::TJsonValue BuildParticipantsJsonReport(const TUsersDB* usersData, const TSet<TString>& participantIds);
};

class TRobotChatHistoryProcessor : public TAppCommonProcessor<TRobotChatHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatHistoryProcessor, TEmptyConfig>;

public:
    TRobotChatHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatActionProcessor : public TAppCommonProcessor<TRobotChatActionProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatActionProcessor, TEmptyConfig>;

public:
    TRobotChatActionProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_action";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatUnreadsProcessor : public TAppCommonProcessor<TRobotChatUnreadsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatUnreadsProcessor, TEmptyConfig>;

public:
    TRobotChatUnreadsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_unreads";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatListProcessor : public TAppCommonProcessor<TRobotChatListProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatListProcessor, TEmptyConfig>;

public:
    TRobotChatListProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatResourceProcessor : public TAppCommonProcessor<TRobotChatResourceProcessor, TEmptyConfig, TBaseProcessor> {
private:
    using TBase = TAppCommonProcessor<TRobotChatResourceProcessor, TEmptyConfig, TBaseProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "robot_chat_resource";
    }

protected:
    virtual void Process(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions) override;
    virtual void ProcessUpload(TJsonReport::TGuard& g, const TString& userId, const TString& chatId, const TString& topic, const TString& resourceId, const TString& content, const TString& contentType);
    virtual void ProcessUploadShared(TJsonReport::TGuard& g, const TString& userId, const TString& resourceId, const TString& content, const TString& contentType);
    virtual void ProcessAcquire(TJsonReport::TGuard& g, const TString& userId, const TString& chatId, const TString& topic, const TString& resourceId);
};

class TRobotChatResetProcessor : public TAppCommonProcessor<TRobotChatResetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatResetProcessor, TEmptyConfig>;

public:
    TRobotChatResetProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_reset";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatRemoveProcessor : public TAppCommonProcessor<TRobotChatRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatRemoveProcessor, TEmptyConfig>;

public:
    TRobotChatRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatResourcePreviewProcessor : public TAppCommonProcessor<TRobotChatResourcePreviewProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatResourcePreviewProcessor, TEmptyConfig>;

public:
    TRobotChatResourcePreviewProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_resource_preview";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRobotChatEditMessageProcessor : public TAppCommonProcessor<TRobotChatEditMessageProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRobotChatEditMessageProcessor, TEmptyConfig>;

public:
    TRobotChatEditMessageProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_edit";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatRobotRateMessage : public TAppCommonProcessor<TChatRobotRateMessage, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatRobotRateMessage, TEmptyConfig>;

public:
    TChatRobotRateMessage(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_rate_message";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatRobotMarkReadProcessor : public TAppCommonProcessor<TChatRobotMarkReadProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatRobotMarkReadProcessor, TEmptyConfig>;

public:
    TChatRobotMarkReadProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_read";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatRobotStickerListProcessor : public TAppCommonProcessor<TChatRobotStickerListProcessor, TChatRobotStickerListProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TChatRobotStickerListProcessor, TChatRobotStickerListProcessorConfig>;

public:
    TChatRobotStickerListProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_sticker_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatRobotStickerEditProcessor : public TAppCommonProcessor<TChatRobotStickerEditProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatRobotStickerEditProcessor, TEmptyConfig>;

public:
    TChatRobotStickerEditProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_sticker_edit";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatRobotStickerHistoryProcessor : public TAppCommonProcessor<TChatRobotStickerHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatRobotStickerHistoryProcessor, TEmptyConfig>;

public:
    TChatRobotStickerHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_sticker_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatAdminFeedProcessor : public TAppCommonProcessor<TChatAdminFeedProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatAdminFeedProcessor, TEmptyConfig>;

public:
    TChatAdminFeedProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_admin_feed";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    NJson::TJsonValue GetFilteredRequestsReport(const TVector<TBasicFilteredSupportRequest>& requests, TSet<TString>& participantIds, const TSupportRequestCategorizationDB* categorizer);
    TMap<TString, TInstant> GetTagsEventTimestamps(const EObjectHistoryAction action, const TSet<TString>& tagIds, NDrive::TEntitySession& session) const;
};

class TChatFilterProcessor : public TAppCommonProcessor<TChatFilterProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatFilterProcessor, TEmptyConfig>;

public:
    TChatFilterProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_filter";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TEditChatFlagsProcessor : public TAppCommonProcessor<TEditChatFlagsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TEditChatFlagsProcessor, TEmptyConfig>;

public:
    TEditChatFlagsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_flags";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatNodeJumpProcessor : public TAppCommonProcessor<TChatNodeJumpProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatNodeJumpProcessor, TEmptyConfig>;

public:
    TChatNodeJumpProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_node_jump";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatDialogueClassifierProcessor : public TAppCommonProcessor<TChatDialogueClassifierProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatDialogueClassifierProcessor, TEmptyConfig>;

public:
    TChatDialogueClassifierProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_ml_classifier";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    NJson::TJsonValue PostprocessClassifyResult(const NDrive::TSupportPrediction& classifyResult);
};

class TChatBulkEvolveProcessor : public TAppCommonProcessor<TChatBulkEvolveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatBulkEvolveProcessor, TEmptyConfig>;

public:
    TChatBulkEvolveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_bulk_evolve";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatGetOrCreateProcessor: public TAppCommonProcessor<TChatGetOrCreateProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatGetOrCreateProcessor, TEmptyConfig>;

public:
    TChatGetOrCreateProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_get_or_create";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TChatGetSuggest: public TAppCommonProcessor<TChatGetSuggest, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TChatGetSuggest, TEmptyConfig>;

public:
    TChatGetSuggest(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "robot_chat_get_suggest";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
