#include "processor.h"

#include <drive/backend/alerts/container.h>
#include <drive/backend/rt_background/common_alerts/process.h>
#include <drive/backend/rt_background/manager/manager.h>

void TAlertsMetaProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr /*permissions*/, const NJson::TJsonValue& /*requestData*/) {
    g.MutableReport().AddReportElement("alerts_meta", NAlerts::TAlertContainer::GetMetaInfo(*Server));
    g.SetCode(HTTP_OK);
}


void TAlertsGroupsListProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) {
    R_ENSURE(Server->GetRTBackgroundManager(), ConfigHttpStatus.NotImplementedState, "rt not configured");
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Observe, TAdministrativeAction::EEntity::RTBackground);

    const TSet<TString> groups = MakeSet(GetStrings(Context->GetCgiParameters(), "groups", false));

    TMap<TString, TRTBackgroundProcessContainer> settings;
    //TMap<TString, TRTBackgroundProcessStateContainer> states;
    auto session = BuildTx<NSQL::ReadOnly>();

    TMap<TString, TVector<NJson::TJsonValue>> alertsByGroup;

    R_ENSURE(Server->GetRTBackgroundManager()->GetSettingsInfo(&session, settings), ConfigHttpStatus.UnknownErrorStatus, "cannot_fetch_infos");
    for (auto&& rtSettings : settings) {
        auto impl = dynamic_cast<const TRTCommonAlertsProcess*>(rtSettings.second.Get());
        if (!impl) {
            continue;
        }

        TString groupName = impl->GetAlert().GetAlertGroupName();

        if (!groups.empty() && !groups.contains(groupName)) {
            continue;
        }

        NJson::TJsonValue report;
        report["bp_type"] = TRTCommonAlertsProcess::GetTypeName();
        report["bp_name"] = rtSettings.first;
        report["bp_enabled"] = rtSettings.second->GetEnabled();
        impl->GetAlert().SerializeToJson(report);
        alertsByGroup[groupName].push_back(report);
    }

    NJson::TJsonValue finalReport;
    for (auto&& group : alertsByGroup) {
        NJson::TJsonValue groupReport;
        groupReport["group_name"] = group.first;
        for (auto&& r : group.second) {
            groupReport["alerts"].AppendValue(r);
        }
        finalReport.AppendValue(groupReport);
    }

    g.MutableReport().AddReportElement("groups", std::move(finalReport));
    g.SetCode(HTTP_OK);
}
