#include "config.h"

bool TCommonAppConfig::ReadMinimalBuildsInfo(const TYandexConfig::Section* section) {
    auto children = section->GetAllChildren();
    auto it = children.find("AppBuildsSelector");
    if (it != children.end()) {
        MinimalBuildsInfo.clear();
        for (auto&& i : it->second->GetDirectives()) {
            ui32 build;
            AssertCorrectConfig(TryFromString(i.second, build), "Incorrect AppBuildsSelector configuration");
            MinimalBuildsInfo[i.first] = build;
        }
    }
    return it != children.end();
}

void TCommonAppConfig::DoInit(const TYandexConfig::Section* section) {
    IAuthRequestProcessorConfig::DoInit(section);
    MinimalBuildsInfoOverriden = ReadMinimalBuildsInfo(section);
    HandlerName = section->GetDirectives().Value("HandlerName", HandlerName);
}

void TCommonAppConfig::ReadDefaults(const TYandexConfig::Section* section) {
    IAuthRequestProcessorConfig::ReadDefaults(section);
    ReadMinimalBuildsInfo(section);
    HandlerName = section->GetDirectives().Value("HandlerName", HandlerName);
}

void TCommonAppConfig::ToString(IOutputStream& os) const {
    IAuthRequestProcessorConfig::ToString(os);
    if (!MinimalBuildsInfo.empty() || MinimalBuildsInfoOverriden) {
        os << "<AppBuildsSelector> " << Endl;
        for (auto&& i : MinimalBuildsInfo) {
            os << i.first << ": " << i.second << Endl;
        }
        os << "</AppBuildsSelector> " << Endl;
    }
    os << "HandlerName: " << HandlerName << Endl;
}
