#pragma once

#include <drive/backend/processors/service_app/config.h>
#include <drive/backend/processors/service_app/processor.h>

class TCreateCompiledRidingProcessor : public TAppCommonProcessor<TCreateCompiledRidingProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCreateCompiledRidingProcessor, TEmptyConfig>;

public:
    TCreateCompiledRidingProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "create_compiled_riding";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TActualSessionsProcessor: public TAppCommonProcessor<TActualSessionsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TActualSessionsProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "actual_sessions";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCloseSessionProcessor : public TAppCommonProcessor<TCloseSessionProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCloseSessionProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "close_session";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCreateCompiledRefundProcessor : public TAppCommonProcessor<TCreateCompiledRefundProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCreateCompiledRefundProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "create_compiled_refund";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSequentialTableInfoProcessor : public TAppCommonProcessor<TSequentialTableInfoProcessor> {
private:
    using TBase = TAppCommonProcessor<TSequentialTableInfoProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "sequential_table_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMemoryInfoProcessor : public TAppCommonProcessor<TMemoryInfoProcessor> {
private:
    using TBase = TAppCommonProcessor<TMemoryInfoProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "memory_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMemorySnapshotProcessor : public TAppCommonProcessor<TMemorySnapshotProcessor> {
private:
    using TBase = TAppCommonProcessor<TMemorySnapshotProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "memory_snapshot";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMemoryProfileProcessor : public TAppCommonProcessor<TMemoryProfileProcessor> {
private:
    using TBase = TAppCommonProcessor<TMemoryProfileProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "memory_profile";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMemoryReleaseProcessor : public TAppCommonProcessor<TMemoryReleaseProcessor> {
private:
    using TBase = TAppCommonProcessor<TMemoryReleaseProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "memory_release";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
