#pragma once

#include <drive/backend/processors/common_app/processor.h>

namespace NDrive {
    struct TDemoCar {
        TString Number;
        TString ModelId;
        TVector<ui64> Features;
        TVector<ui64> Filters;
        NJson::TJsonValue Raw;
    };
    using TDemoCars = TVector<TDemoCar>;
    struct TDemoFeature {
        ui64 Id = 0;
        NJson::TJsonValue Raw;
    };
    using TDemoFeatures = TVector<TDemoFeature>;
    struct TDemoFilter {
        ui64 Id = 0;
        NJson::TJsonValue Raw;
    };
    using TDemoFilters = TVector<TDemoFilter>;
    struct TDemoModel {
        TString Code;
        NJson::TJsonValue Raw;
    };
    using TDemoModels = TMap<TString, TDemoModel>;
    struct TDemoPatch {
        ui64 Index = 0;
        NJson::TJsonValue Raw;
    };
    using TDemoPatches = TVector<TDemoPatch>;
    using TDemoVisibility = TVector<TString>;
    struct TDemoCarList {
        TDemoCars Cars;
        TDemoFeatures Features;
        TDemoFilters Filters;
        TDemoModels Models;
        TDemoPatches Patches;
        TDemoVisibility Visibility;
        NJson::TJsonValue Raw;
    };
}

class TDemoCarListProcessor: public TAppCommonProcessor<TDemoCarListProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TDemoCarListProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "demo_car_list";
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
