#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TShowDistributingBlockProcessor : public TAppCommonProcessor<TShowDistributingBlockProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TShowDistributingBlockProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "show_distributing_block";
    }

private:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetDistributingBlockProcessor : public TAppCommonProcessor<TGetDistributingBlockProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetDistributingBlockProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "get_distributing_block";
    }

private:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class THideDistributingBlockProcessor : public TAppCommonProcessor<THideDistributingBlockProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<THideDistributingBlockProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "hide_distributing_block";
    }

private:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
