#include "processor.h"

#include <drive/backend/offers/actions/rental_offer.h>
#include <drive/backend/roles/manager.h>

void TTariffsListProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) {
    const TCgiParameters& cgi = Context->GetCgiParameters();
    const auto actuality = GetTimestamp(cgi, "actuality", Context->GetRequestStartTime());
    const auto selectedActionId = GetString(cgi, "action_id", true);

    auto tx = BuildTx<NSQL::ReadOnly>();

    auto rentalAction = DriveApi->GetRolesManager()->GetAction(selectedActionId, actuality);
    R_ENSURE(
        rentalAction,
        HTTP_INTERNAL_SERVER_ERROR,
        "cannot get action: " + selectedActionId,
        tx
    );

    auto rentalBuilder = rentalAction->GetAs<TRentalOfferBuilder>();
    R_ENSURE(
        rentalBuilder,
        HTTP_INTERNAL_SERVER_ERROR,
        "rental action is nullptr: " + selectedActionId,
        tx
    );

    R_ENSURE(
        permissions->CheckAdministrativeActions(TAdministrativeAction::EAction::Observe, TAdministrativeAction::EEntity::Action, TypeName, rentalBuilder->GetType()),
        HTTP_INTERNAL_SERVER_ERROR,
        "user has no permissions to observe: " + selectedActionId,
        tx
    );

    auto report = rentalBuilder->BuildJsonReport();
    rentalBuilder->PatchReport(report, GetLocale(), *Server, tx, permissions);
    g.MutableReport().AddReportElement("report", std::move(report));

    g.SetCode(HTTP_OK);
}
