#include "processor.h"

#include <drive/backend/cars/car_model.h>
#include <drive/backend/data/leasing/acl/acl.h>
#include <drive/backend/data/leasing/company.h>

void TCarModelDeleteProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) {
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Remove, TAdministrativeAction::EEntity::Models);
    auto tx = BuildTx<NSQL::Writable | NSQL::RepeatableRead>();

    TSet<TString> codes = MakeSet(GetStrings(Context->GetCgiParameters(), "id", true));

    auto acl = NDrivematics::TACLTag::GetACLTag(permissions, tx, *Server);
    auto aclCompany = acl->GetCompanyTagDescription(permissions->GetUserId(), *Server);

    TMessagesCollector errors;

    R_ENSURE(
          aclCompany->RemoveEntityObjects(GetEntityType(), codes, permissions, Server, tx, NDrivematics::TACLTag::ERemoveEntityPolicy::Object)
        , HTTP_FORBIDDEN
        , "cannot remove objects from company, " << errors.GetStringReport()
        , NDrive::MakeError("acl.remove")
        , tx
    );

    R_ENSURE(
          Server->GetDriveAPI()->GetTagsManager().GetTagsMeta().RegisterTag(aclCompany, permissions->GetUserId(), tx)
        , {}
        , "cannot update acl tag"
        , NDrive::MakeError("acl.update")
        , tx
    );
    R_ENSURE(tx.Commit(), {}, "cannot commit", NDrive::MakeError("tx.save"), tx);

    g.SetCode(HTTP_OK);
}
