#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TCarModelDeleteProcessor: public TAppCommonProcessor<TCarModelDeleteProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelDeleteProcessor, TEmptyConfig>;
public:
    TCarModelDeleteProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_model/delete";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    static TAdministrativeAction::EEntity GetEntityType() {
        return TAdministrativeAction::EEntity::Models;
    }
};
