#include "processor.h"

#include <drive/backend/cars/car_model.h>
#include <drive/backend/data/leasing/acl/acl.h>
#include <drive/backend/data/leasing/company.h>

void TCarModelListProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) {
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Observe, TAdministrativeAction::EEntity::Models);
    TSet<TString> codes = MakeSet(GetStrings(Context->GetCgiParameters(), "id", false));
    auto showDeleted = GetValue<bool>(Context->GetCgiParameters(), "show_deleted", false).GetOrElse(false);

    auto tx = BuildTx<NSQL::ReadOnly>();

    auto acl = NDrivematics::TACLTag::GetACLTag(permissions, tx, *Server);
    auto aclCompany = acl->GetCompanyTagDescription(permissions->GetUserId(), *Server);
    auto modelCodes = aclCompany->GetEntityObjects(GetEntityType(), permissions);

    if (!codes.empty()) {
        modelCodes = MakeIntersection(codes, modelCodes);
        R_ENSURE(
              modelCodes.size() == codes.size()
            , HTTP_INTERNAL_SERVER_ERROR
            , "code has not found in acl tag"
            , NDrive::MakeError("car_model.model_not_found")
            , tx);
    }

    auto modelInfo = Server->GetDriveAPI()->GetModelsData()->FetchInfo(modelCodes, tx);
    R_ENSURE(
          modelInfo
        , HTTP_INTERNAL_SERVER_ERROR
        , "cannot fetch models"
        , NDrive::MakeError("car_model.read_model_error")
        , tx);

    NJson::TJsonValue jModels;
    for (auto&& carModel : modelInfo.GetResult()) {
        if (showDeleted || !carModel.second.HasDeprecated() || !carModel.second.GetDeprecatedRef()) {
            jModels.AppendValue(carModel.second.GetReport(GetLocale(), NDriveModelReport::ReportAll));
        }
    }

    g.MutableReport().AddReportElement("models", std::move(jModels));
    g.SetCode(HTTP_OK);
}
