#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TCarModelUpdateProcessor: public TAppCommonProcessor<TCarModelUpdateProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCarModelUpdateProcessor, TEmptyConfig>;
public:
    TCarModelUpdateProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "car_model/update";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    static TAdministrativeAction::EEntity GetEntityType() {
        return TAdministrativeAction::EEntity::Models;
    }
};
