#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TRentalOffer;

class TOffersBookRentalProcessor: public TAppCommonProcessor<TOffersBookRentalProcessor> {
private:
    using TBase = TAppCommonProcessor<TOffersBookRentalProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "rental/book";
    }
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    enum class EUserIdStatus {
        Created,
        Exists
    };

private:
    TAtomicSharedPtr<TRentalOffer> GetOffer(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions,
                                            const TString& offerId, NDrive::TEntitySession& session);
    std::pair<EUserIdStatus, TString> GetClientId(TUserPermissions::TPtr permissions, NDrive::TEntitySession& session,
                                                  const NJson::TJsonValue& requestData);
};
