#include "processor.h"

#include <drive/backend/offers/actions/rental_offer.h>
#include <drive/backend/rt_background/rental/process.h>
#include <drive/backend/roles/manager.h>

void TRentalStartProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) {
    const TCgiParameters& cgi = Context->GetCgiParameters();
    const auto tagId = GetString(cgi, "tag_id", true);

    auto tx = BuildTx<NSQL::Writable>();
    auto& manager = Server->GetDriveAPI()->GetTagsManager().GetUserTags();
    auto optionalTag = manager.RestoreTag(tagId, tx);
    R_ENSURE(optionalTag, HTTP_INTERNAL_SERVER_ERROR, "cannot get RentalOfferHolderTag", tx);
    R_ENSURE(optionalTag->GetData(), HTTP_INTERNAL_SERVER_ERROR, "RentalOfferHolderTag does not exists", NDrive::MakeError("rental.tag_does_not_exists"), tx);
    auto pTag = std::dynamic_pointer_cast<TRentalOfferHolderTag>(optionalTag->GetData());
    R_ENSURE(pTag, HTTP_INTERNAL_SERVER_ERROR, "cannot cast to RentalOfferHolderTag", tx);
    auto offer = std::dynamic_pointer_cast<TRentalOffer>(pTag->GetOffer());
    R_ENSURE(offer, HTTP_INTERNAL_SERVER_ERROR, "RentalOffer is nullptr", tx);
    // will be deleted after frontend update
    if (!Server->GetSettings().GetValue<bool>("rental.is_old_start_riding_flow").GetOrElse(true)) {
        R_ENSURE(offer->HasStatus() && offer->GetStatusRef() == TRentalOfferHolderTag::GetPaidOfferStatus(), HTTP_INTERNAL_SERVER_ERROR, "booking has not paid", NDrive::MakeError("rental.booking_has_not_paid"), tx);
    }
    R_ENSURE(TRentalOfferHolderTag::Start(*optionalTag, *permissions, Server, tx, "RentalStartProcessor::ProcessServiceRequest", offer->GetObjectId()), HTTP_INTERNAL_SERVER_ERROR, "cannot start rental", tx);
    R_ENSURE(tx.Commit(), HTTP_INTERNAL_SERVER_ERROR, "cannot Commit", tx);
    g.SetCode(HTTP_OK);
}
