#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TRentalStartProcessor: public TAppCommonProcessor<TRentalStartProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRentalStartProcessor, TEmptyConfig>;
public:
    TRentalStartProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "rental/start";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
