#include "processor.h"

#include <rtline/library/json/cast.h>

void TUpsertExternalAccessTokensProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Add, TAdministrativeAction::EEntity::ExternalAccessToken);
    TString token = GetString(requestData, "token");
    TString userId = GetString(requestData, "user_id");
    TString scope = GetString(requestData, "scope", false);
    TVector<TString> ipWhiteList;
    const NJson::TJsonValue* path = requestData.GetValueByPath("ip_whitelist");
    R_ENSURE(path && NJson::TryFromJson(*path, ipWhiteList), ConfigHttpStatus.SyntaxErrorStatus, "malformed or missing ip_whitelist");
    R_ENSURE(Server->GetExternalAccessTokensManager() &&
                    Server->GetExternalAccessTokensManager()->Upsert(token, ipWhiteList, userId, scope, permissions->GetUserId()),
                    ConfigHttpStatus.UnknownErrorStatus, "can not upsert external token");
    g.AddReportElement("token", token);
    g.AddReportElement("user_id", userId);
    g.AddReportElement("ip_whitelist", NJson::ToJson(ipWhiteList));
    g.SetCode(HTTP_OK);
}

void TInvalidateExternalAccessTokensProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Remove, TAdministrativeAction::EEntity::ExternalAccessToken);
    TString token = GetString(requestData, "token");
    R_ENSURE(Server->GetExternalAccessTokensManager() && Server->GetExternalAccessTokensManager()->Invalidate(token, permissions->GetUserId()),
                    ConfigHttpStatus.UnknownErrorStatus, "can not delete external token");
    g.AddReportElement("token", token);
    g.SetCode(HTTP_OK);
}
