#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/auth/external/database.h>

class TUpsertExternalAccessTokensProcessor: public TAppCommonProcessor<TUpsertExternalAccessTokensProcessor> {
private:
    using TBase = TAppCommonProcessor<TUpsertExternalAccessTokensProcessor>;
    using TConfig = typename TBase::THandlerConfig;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "upsert_external_access_token";
    }

public:
    using TBase::TBase;
};

class TInvalidateExternalAccessTokensProcessor: public TAppCommonProcessor<TInvalidateExternalAccessTokensProcessor> {
private:
    using TBase = TAppCommonProcessor<TInvalidateExternalAccessTokensProcessor>;
    using TConfig = typename TBase::THandlerConfig;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "invalidate_external_access_token";
    }

public:
    using TBase::TBase;
};
