#include "callback.h"

void TExternalChatAttachmentCallback::OnSuccess(const TString& /*resourceId*/) {
    auto current = CurrentFinishedCount.Inc();
    if (current == static_cast<TAtomicBase>(AttachmentsCount)) {
        TJsonReport::TGuard g(Report, HTTP_OK);
        auto session = ChatRobot->BuildChatEngineSession();
        NDrive::NChat::TMessage chatMessage(MessageText, 0, NDrive::NChat::TMessage::EMessageType::MediaResources);
        chatMessage.SetExternalId(ExternalId);
        chatMessage.SetExternalStatus(NDrive::NChat::TMessage::EExternalStatus::Sent);
        if (!ChatRobot->SendArbitraryMessage(UserId, Topic, UserId, chatMessage, session) || !session.Commit()) {
            g.MutableReport().AddReportElement("error", "Can't send message with attachments to chat " + MessageText + ". Session report: " + session.GetStringReport());
            g.SetCode(HttpCodes::HTTP_INTERNAL_SERVER_ERROR);
        } else {
            g.SetCode(HttpCodes::HTTP_OK);
        }
    }
}

void TExternalChatAttachmentCallback::OnFailure(const TString& errorMessage, const HttpCodes code) {
    TJsonReport::TGuard g(Report, code);
    g.MutableReport().AddReportElement("error", "Can't send message with attachments to chat: " + errorMessage);
    g.SetCode(code);
}
