#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/abstract/base.h>
#include <drive/backend/chat_robots/abstract.h>

#include <util/generic/refcount.h>

class TExternalChatAttachmentCallback: public IChatMediaResourcePostUploadCallback {
public:
    TExternalChatAttachmentCallback(IServerReportBuilder::TPtr report, IChatRobot::TPtr chatRobot, const ui32 attachmentsCount, const TString& messageText, const TString& userId, const TString& topic, const TString& externalId)
        : Report(report)
        , ChatRobot(chatRobot)
        , AttachmentsCount(attachmentsCount)
        , MessageText(messageText)
        , UserId(userId)
        , Topic(topic)
        , ExternalId(externalId)
    {
    }
    virtual void OnSuccess(const TString& resourceId) override;
    virtual void OnFailure(const TString& errorMessage, const HttpCodes code = HttpCodes::HTTP_INTERNAL_SERVER_ERROR) override;

private:
    IServerReportBuilder::TPtr Report;
    IChatRobot::TPtr ChatRobot;
    ui32 AttachmentsCount;
    TAtomicCounter CurrentFinishedCount = 0;
    const TString MessageText;
    const TString UserId;
    const TString Topic;
    const TString ExternalId;
};
