#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/chat/message.h>
#include <drive/backend/data/user_tags.h>

#include <util/generic/serialized_enum.h>

class TExternalChatMessageProcessor: public TAppCommonProcessor<TExternalChatMessageProcessor, TEmptyConfig> {
public:
    enum class EExternalMessageType: ui32 {
        FromUser/* "from_user" */ = 0,
        Comment /* "comment" */ = 1
    };

    class TExternalMessage {
        R_FIELD(NDrive::NChat::TMessage, Message);
        R_FIELD(TInstant, SendTime);
        R_FIELD(EExternalMessageType, MessageType, EExternalMessageType::FromUser);
        R_FIELD(TSet<TString>, AttachmentIds);

    public:
        bool operator< (const TExternalMessage& obj) const {
            if (SendTime == obj.GetSendTime()) {
                return Message.GetExternalId() < obj.GetMessage().GetExternalId();
            } else {
                return SendTime < obj.GetSendTime();
            }
        }

        ui32 GetMessageTraits() const;
    };

private:
    using TBase = TAppCommonProcessor<TExternalChatMessageProcessor, TEmptyConfig>;

public:
    TExternalChatMessageProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "external_chat_message";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

protected:
    virtual void Parse(const NJson::TJsonValue& requestData) override;

private:
    TExternalMessage DeserializeMessageFromJson(const NJson::TJsonValue& requestData) const;
    void FillHandlerSettingsValues();
    TMaybe<std::pair<TDBTag, TString>> GetSupportChatTagAndTopicLink(const TString& userId, const TString& topic) const;

    TString Provider;
    TString ExternalChatId;
    TInstant ReadMessagesUntil;
    NJson::TJsonValue ChatMeta;
    TSet<TExternalMessage> ExternalMessages;
    TString ChatTagName;
    TString ChatId;
    TString OperatorId;
    TString InitialNode;
    bool Closed = false;
};
