#pragma once

#include <drive/backend/abstract/base.h>
#include <drive/backend/abstract/frontend.h>
#include <drive/backend/report/abstract.h>

#include <drive/telematics/server/location/location.h>

#include <rtline/api/graph/router/router.h>
#include <rtline/library/geometry/coord.h>
#include <rtline/library/geometry/rect.h>
#include <rtline/util/types/accessor.h>

class IRequestProcessor;
class TExternalOfferConfig;
class TUserPermissions;

namespace NExternalOfferImpl {
    struct TCarInfo {
        TString Id;
        TString ModelId;
        NDrive::TLocation Location;
        TDuration WalkingTime;
        TMaybe<double> WalkingDistance;
    };
    using TCarsInfo = TVector<TCarInfo>;
}

class TNearestCarsDetector {
private:
    const NDrive::IServer* Server = nullptr;
    const TUserPermissions& Permissions;
    TMaybe<TGeoRect> FinalBoundingBox;
    IServerReportBuilder* Report = nullptr;
    R_FIELD(TSet<TString>, StatusFilterSet);
    R_FIELD(TInstant, Deadline, TInstant::Zero());
    R_FIELD(TGeoCoord, Source);
    R_FIELD(bool, UseRoutingMatrix, true);
    R_FIELD(bool, Sparcify, false);
    R_FIELD(double, SparcifyProximityThreshold, 50);
    R_FIELD(double, WalkingDistanceLimit, 500);

private:
    NExternalOfferImpl::TCarsInfo FetchCars(const TGeoRect& rect) const;

public:
    TNearestCarsDetector(const NDrive::IServer* server, const TUserPermissions& permissions, IServerReportBuilder* report = nullptr)
        : Server(server)
        , Permissions(permissions)
        , Report(report)
    {
    }

    bool Initialize(const TGeoCoord& source, const IRequestProcessor* processor);
    bool GetCars(const ui32 carsLimit, TVector<NExternalOfferImpl::TCarInfo>& result) const;
};
