#pragma once

#include "fetchers.h"

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/offers/context.h>
#include <drive/backend/offers/actions/offer_price.h>

namespace NExternalOfferImpl {
    struct TCarInfo;
    struct TUserInfo;
    using TOfferPtr = IOfferReport::TPtr;
    using TOffersInfo = TVector<TOfferPtr>;
}  // namespace NExternalOfferImpl

class TExternalOfferConfig {
    R_READONLY(bool, UseCustomOfferReport, true);
    R_READONLY(bool, SuggestOfferReport, false);

public:
    void InitFeatures(const TYandexConfig::Section* section) {
        const auto& directives = section->GetDirectives();
        UseCustomOfferReport = directives.Value("UseCustomOfferReport", UseCustomOfferReport);
        SuggestOfferReport = directives.Value("SuggestOfferReport", SuggestOfferReport);
    }

    void ToStringFeatures(IOutputStream& os) const {
        os << "UseCustomOfferReport: " << UseCustomOfferReport << Endl;
        os << "SuggestOfferReport: " << SuggestOfferReport << Endl;
    }
};

class TExternalOfferProcessor: public TAppCommonProcessor<TExternalOfferProcessor, TExternalOfferConfig> {
private:
    using TBase = TAppCommonProcessor<TExternalOfferProcessor, TExternalOfferConfig>;
public:
    TExternalOfferProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "external_offer";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    NExternalOfferImpl::TOffersInfo BuildOffers(
        const NExternalOfferImpl::TCarsInfo& cars,
        const TUserOfferContext& uhc,
        NExternalOfferImpl::TOffersInfo& complementary,
        NDrive::TInfoEntitySession& session,
        TJsonReport& report
    );

private:
    TMap<TString, ui64> ErrorCounts;
};
