#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/abstract/base.h>
#include <drive/backend/fines/manager.h>

#include <drive/library/cpp/scheme/scheme.h>

namespace NDrive::NFine {
    class TFineRefundTagConfig;
    class TFineFetchContextConfig;
}

class TCheckDriverLicenseProcessor: public TAppCommonProcessor<TCheckDriverLicenseProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCheckDriverLicenseProcessor, TEmptyConfig>;

public:
    TCheckDriverLicenseProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "user_fines/check_driver_license";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TResendFineEmailProcessor: public TAppCommonProcessor<TResendFineEmailProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TResendFineEmailProcessor, TEmptyConfig>;

public:
    TResendFineEmailProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "user_fines/resend_email";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUpsertUserFinesProcessor: public TAppCommonProcessor<TUpsertUserFinesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUpsertUserFinesProcessor, TEmptyConfig>;

public:
    TUpsertUserFinesProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "user_fines/upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TReAssignUserFinesProcessor: public TAppCommonProcessor<TReAssignUserFinesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TReAssignUserFinesProcessor, TEmptyConfig>;

public:
    TReAssignUserFinesProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , RefundTagConfig(MakeHolder<NDrive::NFine::TFineRefundTagConfig>())
        , ContextConfig(MakeHolder<NDrive::NFine::TFineFetchContextConfig>())
    {
    }

    static TString GetTypeName() {
        return "user_fines/reassign";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    void Parse(const NJson::TJsonValue& requestData) override;

private:
    ITag::TPtr PrepareRefundTag(const NDrive::NFine::TAutocodeFineEntry& fine, NDrive::TEntitySession& session) const;
    bool UpdateFineRelatedTagIds(NDrive::NFine::TAutocodeFineEntry& fine, const TVector<TString>& tagIds) const;

    bool CheckIsTargetUserSet(const TString& targetUserId, const TString& targetSessionId) const;

    R_READONLY(TString, FineId);

    R_READONLY(bool, DoRefund, false);
    R_READONLY(TString, RefundComment);

    R_READONLY(bool, RequireSessionRebound, false);

    R_OPTIONAL(bool, IsTargetUserSet);

    R_READONLY(TString, TargetUserId);
    R_READONLY(TString, TargetSessionId);
    R_READONLY(ui32, TargetSkipped, 0);

    THolder<NDrive::NFine::TFineRefundTagConfig> RefundTagConfig;
    THolder<NDrive::NFine::TFineFetchContextConfig> ContextConfig;
};

class TListUserFinesProcessor: public TAppCommonProcessor<TListUserFinesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TListUserFinesProcessor, TEmptyConfig>;

public:
    TListUserFinesProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "user_fines/list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /* requestData */) override;

    static NDrive::TScheme GetCgiParametersScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const TCgiParameters& cgi) override;

private:
    static constexpr size_t MaxLimit = 100;

    R_READONLY(bool, ExtendedInfo, false);

    R_READONLY(TString, FineId);
    R_READONLY(TString, UserId);
    R_READONLY(TString, CarId);
    R_READONLY(bool, ChargedOnly, true);
    R_READONLY(bool, UseCents, true);

    R_READONLY(TInstant, Since);
    R_READONLY(TInstant, Until);
    R_READONLY(size_t, Offset, 0);
    R_READONLY(size_t, Limit, MaxLimit);
};

class TFineDecreeInfoProcessor: public TAppCommonProcessor<TFineDecreeInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TFineDecreeInfoProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_fines/decree_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    static NDrive::TScheme GetCgiParametersScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const TCgiParameters& cgi) override;

private:
    R_READONLY(TString, FineId);
};
