#pragma once

#include "common.h"

class TFuelingInfoProcessor: public TAppCommonProcessor<TFuelingInfoProcessor, TEmptyConfig>, private TFuelingCommon {
private:
    using TBase = TAppCommonProcessor<TFuelingInfoProcessor, TEmptyConfig>;

public:
    TFuelingInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , TFuelingCommon(server)
    {
    }

    static TString GetTypeName() {
        return "fueling_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;
};

class TFuelingMapProcessor: public TAppCommonProcessor<TFuelingMapProcessor, TEmptyConfig>, private TFuelingCommon {
private:
    using TBase = TAppCommonProcessor<TFuelingMapProcessor, TEmptyConfig>;

public:
    TFuelingMapProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , TFuelingCommon(server) {
    }

    static TString GetTypeName() {
        return "fueling_map";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;
};

class TStartFuelingProcessor: public TAppCommonProcessor<TStartFuelingProcessor, TEmptyConfig>, private TFuelingCommon {
private:
    using TBase = TAppCommonProcessor<TStartFuelingProcessor, TEmptyConfig>;

public:
    struct TOrdererInfo {
        TString UserId;
        TString CarId;
        TString SessionId;
        EFuelClientType ClientType;
        TString PickedColumnId;
    };

public:
    TStartFuelingProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , TFuelingCommon(server) {
    }

    static TString GetTypeName() {
        return "fueling_start";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;

private:
    void StartPrePayFueling(TDBTag& userFuelingTag, const TOrdererInfo& ordererInfo, TFuelingContext& fuelingContex, const TMaybe<double> litersUpperBound) const;
    void StartPostPayFueling(const TOrdererInfo& ordererInfo, const TFuelingContext& fuelingContex, const double allowedError) const;
};

class TCancelFuelingProcessor: public TAppCommonProcessor<TCancelFuelingProcessor, TEmptyConfig>, private TFuelingCommon {
private:
    using TBase = TAppCommonProcessor<TCancelFuelingProcessor, TEmptyConfig>;

public:
    TCancelFuelingProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , TFuelingCommon(server) {
    }

    static TString GetTypeName() {
        return "fueling_cancel";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;
};
