#pragma once

#include "common.h"


class TSupportCreateFuelingOrderProcessor: public TAppCommonProcessor<TSupportCreateFuelingOrderProcessor, TEmptyConfig>, private TFuelingCommon {
private:
    using TBase = TAppCommonProcessor<TSupportCreateFuelingOrderProcessor, TEmptyConfig>;

    TDBTag UpsertFuelingTag(TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) const;
public:
    TSupportCreateFuelingOrderProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , TFuelingCommon(server) {
    }

    static TString GetTypeName() {
        return "support_create_fueling_order";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
};

class TSupportGetFuelStationColumnsProcessor: public TAppCommonProcessor<TSupportGetFuelStationColumnsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportGetFuelStationColumnsProcessor, TEmptyConfig>;

public:
    TSupportGetFuelStationColumnsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_fueling_station_columns";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    static NDrive::TScheme GetCgiParametersScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
};
