#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/processor.h>

class TRegisterHeadProcessor: public TAppCommonProcessor<TRegisterHeadProcessor> {
private:
    using TBase = TAppCommonProcessor<TRegisterHeadProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "register_head";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetSessionKeyProcessor: public TAppCommonProcessor<TGetSessionKeyProcessor> {
private:
    using TBase = TAppCommonProcessor<TGetSessionKeyProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "get_session_key";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TDropPublicKeyProcessor: public TAppCommonProcessor<TDropPublicKeyProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TDropPublicKeyProcessor, TEmptyConfig>;
public:
    TDropPublicKeyProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "drop_public_key";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class THeadInfoProcessor: public TAppCommonProcessor<THeadInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<THeadInfoProcessor, TEmptyConfig>;
public:
    THeadInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "head_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRegisterNewHeadForCarProcessor : public TAppCommonProcessor<TRegisterNewHeadForCarProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRegisterNewHeadForCarProcessor, TEmptyConfig>;
public:
    TRegisterNewHeadForCarProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "register_new_head_id";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetSessionForHeadProcessor : public TAppCommonProcessor<TGetSessionForHeadProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetSessionForHeadProcessor, TEmptyConfig>;
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "get_session_by_head_device";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
