#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TDriveAPI;
class TRolesManager;

class TIDMCommonProcessor : public TAuthRequestProcessor {
public:
    using TAuthRequestProcessor::Process;

protected:
    struct TModifyRoleRequest {
        TString User;
        TString Role;
    };

protected:
    using TAuthRequestProcessor::TAuthRequestProcessor;

    const TDriveAPI& GetAPI() const;
    const TRolesManager& GetRolesManager() const;
    TUsersDB& GetUsersDB() const;

    TModifyRoleRequest ParseRequest(const TString& operatorUserId, NDrive::TEntitySession& session) const;

    virtual void DoAuthProcess(TJsonReport::TGuard& g, IAuthInfo::TPtr authInfo) override;
    virtual void Process(TJsonReport::TGuard& g, IAuthInfo::TPtr authInfo) = 0;
};

class TIDMInfoProcessor: public TIDMCommonProcessor {
private:
    using TBase = TIDMCommonProcessor;

public:
    using TBase::TBase;

    virtual void Process(TJsonReport::TGuard& g, IAuthInfo::TPtr authInfo) override;
};

class TIDMAddRoleProcessor : public TIDMCommonProcessor {
private:
    using TBase = TIDMCommonProcessor;

public:
    using TBase::TBase;

    virtual void Process(TJsonReport::TGuard& g, IAuthInfo::TPtr authInfo) override;
};

class TIDMRemoveRoleProcessor : public TIDMCommonProcessor {
private:
    using TBase = TIDMCommonProcessor;

public:
    using TBase::TBase;

    virtual void Process(TJsonReport::TGuard& g, IAuthInfo::TPtr authInfo) override;
};

class TIDMGetAllRolesProcessor : public TIDMCommonProcessor {
private:
    using TBase = TIDMCommonProcessor;

public:
    using TBase::TBase;

    virtual void Process(TJsonReport::TGuard& g, IAuthInfo::TPtr authInfo) override;
};
