#include "config.h"

void TRegisterPhotoProcessorConfig::InitFeatures(const TYandexConfig::Section* section) {
    ReportResultSnapshot = section->GetDirectives().Value("ReportResultSnapshot", ReportResultSnapshot);
    RequireTagPerform = section->GetDirectives().Value("RequireTagPerform", RequireTagPerform);
    GeneratePreviewPath = section->GetDirectives().Value("GeneratePreviewPath", GeneratePreviewPath);
}

void TRegisterPhotoProcessorConfig::ToStringFeatures(IOutputStream& os) const {
    os << "ReportResultSnapshot: " << ReportResultSnapshot << Endl;
    os << "RequireTagPerform: " << RequireTagPerform << Endl;
    os << "GeneratePreviewPath: " << GeneratePreviewPath << Endl;
}

void TUploadPhotoProcessorConfig::InitFeatures(const TYandexConfig::Section* section) {
    const auto& directives = section->GetDirectives();
    EnableServiceSessions = directives.Value("EnableServiceSessions", EnableServiceSessions);
    AcceptanceInterval = directives.Value("AcceptanceInterval", AcceptanceInterval);
    BucketName = directives.Value("BucketName", BucketName);
    PreviewMaxSideSize = directives.Value("PreviewMaxSideSize", PreviewMaxSideSize);
}

void TUploadPhotoProcessorConfig::ToStringFeatures(IOutputStream& os) const {
    os << "EnableServiceSessions: " << EnableServiceSessions << Endl;
    os << "AcceptanceInterval: " << AcceptanceInterval << Endl;
    os << "BucketName: " << BucketName << Endl;
    os << "PreviewMaxSideSize: " << PreviewMaxSideSize << Endl;
}
