#pragma once

#include <drive/backend/processors/common_app/config.h>

class TRegisterPhotoProcessorConfig {
    R_READONLY(bool, ReportResultSnapshot, false);
    R_READONLY(bool, RequireTagPerform, true);

    R_READONLY(bool, GeneratePreviewPath, true);

public:
    void InitFeatures(const TYandexConfig::Section* section);
    void ToStringFeatures(IOutputStream& os) const;
};

class TUploadPhotoProcessorConfig {
    R_READONLY(bool, EnableServiceSessions, true);  // basically use tags history; use active tags only otherwise
    R_READONLY(TDuration, AcceptanceInterval, TDuration::Days(42));  // tags or service sessions history deep

    R_READONLY(TString, BucketName, "carsharing-acceptances");  // either carsharing-acceptances or carsharing-tags is used

    R_READONLY(size_t, PreviewMaxSideSize, 300);

public:
    void InitFeatures(const TYandexConfig::Section* section);
    void ToStringFeatures(IOutputStream& os) const;
};
