#pragma once

#include "config.h"

#include <drive/backend/data/complaint_tags/car_complaint.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/offers/offers/abstract.h>

#include <drive/library/cpp/mds/client.h>

class TRegisterPhotoProcessor: public TAppCommonProcessor<TRegisterPhotoProcessor, TRegisterPhotoProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TRegisterPhotoProcessor, TRegisterPhotoProcessorConfig>;

public:
    TRegisterPhotoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "register_photo";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    NJson::TJsonValue GetTagDerivedMetaData(const NEntityTagsManager::EEntityType entityType, const TDBTag& tag) const;
    TMaybe<TCarComplaintConfig> GetComplaintConfig(const TString& complaintId, const NJson::TJsonValue& requestData) const;
};

class TGetServicePhotoProcessor: public TAppCommonProcessor<TGetServicePhotoProcessor> {
private:
    using TBase = TAppCommonProcessor<TGetServicePhotoProcessor>;

public:
    TGetServicePhotoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "get_service_photo";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetMarkedPhotosProcessor: public TAppCommonProcessor<TGetMarkedPhotosProcessor> {
private:
    using TBase = TAppCommonProcessor<TGetMarkedPhotosProcessor>;

public:
    TGetMarkedPhotosProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "get_marked_photos";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUploadServicePhotoProcessor: public TAppCommonProcessor<TUploadServicePhotoProcessor, TUploadPhotoProcessorConfig, TBaseProcessor> {
private:
    using TBase = TAppCommonProcessor<TUploadServicePhotoProcessor, TUploadPhotoProcessorConfig, TBaseProcessor>;

    struct TImageToUploadDescription {
        ui64 ImageId;
        TString Path;
        TString PreviewPath;
        TString MD5;

        TImageToUploadDescription(ui64 imageId, const TString& path, const TString& previewPath, const TString& md5)
            : ImageId(imageId)
            , Path(path)
            , PreviewPath(previewPath)
            , MD5(md5)
        {
        }
    };

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "upload_service_photo";
    }

    void Process(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions) override;

private:
    TMaybe<TImageToUploadDescription> FetchImageDescriptionFromTags(const IEntityTagsManager& entityTags, const TString& objectId, const TString& photoId) const;
    TMaybe<TImageToUploadDescription> FetchImageDescriptionFromTagsHistory(const IEntityTagsManager& entityTags, const TString& objectId, const TString& photoId, const TInstant acceptanceTs) const;
};

class TUpdatePhotoMetaDataProcessor: public TAppCommonProcessor<TUpdatePhotoMetaDataProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUpdatePhotoMetaDataProcessor, TEmptyConfig>;

public:
    TUpdatePhotoMetaDataProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "update_photo_meta_data";
    }

    static NDrive::TScheme GetRequestDataScheme(const NDrive::IServer* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const NJson::TJsonValue& requestData) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(ui64, ImageId, 0);
    R_READONLY(NJson::TJsonValue, MetaData);
};

class TUpdatePhotoMarkUpProcessor: public TAppCommonProcessor<TUpdatePhotoMarkUpProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUpdatePhotoMarkUpProcessor, TEmptyConfig>;

public:
    TUpdatePhotoMarkUpProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "update_photo_markup";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TInvalidateMarkUpProcessor: public TAppCommonProcessor<TInvalidateMarkUpProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TInvalidateMarkUpProcessor, TEmptyConfig>;

public:
    TInvalidateMarkUpProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "invalidate_photo_markup";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSelectMarkUpProcessor: public TAppCommonProcessor<TSelectMarkUpProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSelectMarkUpProcessor, TEmptyConfig>;

public:
    TSelectMarkUpProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "select_photo_markup";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
