#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/context_fetcher/json.h>
#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/filters.h>
#include <drive/backend/incident/incident.h>
#include <drive/backend/notifications/collection.h>

#include <drive/library/cpp/scheme/scheme.h>

class TInitiateIncidentProcessor: public TAppCommonProcessor<TInitiateIncidentProcessor, TEmptyConfig> {
    using TBase = TAppCommonProcessor<TInitiateIncidentProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "initiate_incident";
    }

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const NJson::TJsonValue& requestData) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(NDrive::TIncidentData, Instance);
};

class TInitiateEvacuationProcessor: public TAppCommonProcessor<TInitiateEvacuationProcessor, TEmptyConfig> {
    using TBase = TAppCommonProcessor<TInitiateEvacuationProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "initiate_evacuation";
    }

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const NJson::TJsonValue& requestData) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(NDrive::TIncidentData, Instance, NDrive::TIncidentData(NDrive::EIncidentType::Evacuation));
};

class TUploadIncidentStartrekAttachmentProcessor: public TAppCommonProcessor<TUploadIncidentStartrekAttachmentProcessor, TEmptyConfig> {
    using TBase = TAppCommonProcessor<TUploadIncidentStartrekAttachmentProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "incident_startrek_attachment";
    }

    static NDrive::TScheme GetCgiParametersScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const TCgiParameters& cgi) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(TString, FileName);
    R_READONLY(TString, MD5);
};

class TCreateIncidentProcessor: public TAppCommonProcessor<TCreateIncidentProcessor, TEmptyConfig> {
    using TBase = TAppCommonProcessor<TCreateIncidentProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "create_incident";
    }

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const NJson::TJsonValue& requestData) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(NDrive::TIncidentData, Instance);
};

class TListIncidentsProcessor: public TAppCommonProcessor<TListIncidentsProcessor, TEmptyConfig> {
    using TBase = TAppCommonProcessor<TListIncidentsProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "list_incidents";
    }

    static NDrive::TScheme GetCgiParametersScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const TCgiParameters& cgi) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    NJson::TJsonValue GetTagsDesciption(const IEntityTagsManager& tagsManagerImpl, const TSet<TString>& tagIds, NDrive::TEntitySession& session) const;

private:
    static constexpr size_t MaxLimit = 100;

    R_READONLY(NDrive::TIncidentFilterGroup, Filters);

    R_READONLY(size_t, Offset, 0);
    R_READONLY(size_t, Limit, MaxLimit);
};

class TPerformIncidentTransitionProcessor: public TAppCommonProcessor<TPerformIncidentTransitionProcessor, TEmptyConfig> {
    using TBase = TAppCommonProcessor<TPerformIncidentTransitionProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "perform_incident_transition";
    }

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
    virtual void Parse(const NJson::TJsonValue& requestData) override;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(TString, IncidentId);
    R_READONLY(NDrive::EIncidentTransition, TransitionId);
    R_READONLY(NJson::TJsonValue, TransitionData);
};
