#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/db_entities.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/database/drive/landing.h>

class TLandingInfoProcessor: public TAppCommonProcessor<TLandingInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLandingInfoProcessor, TEmptyConfig>;
public:
    TLandingInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "landing_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLandingAcceptProcessor: public TAppCommonProcessor<TLandingAcceptProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLandingAcceptProcessor, TEmptyConfig>;
public:
    TLandingAcceptProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "landing_accept";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLandingsClearProcessor: public TAppCommonProcessor<TLandingsClearProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLandingsClearProcessor, TEmptyConfig>;
public:
    TLandingsClearProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "user_landings_clear";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLandingUpsertProcessor : public TAppCommonProcessor<TLandingUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLandingUpsertProcessor, TEmptyConfig>;
public:
    TLandingUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "landing_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLandingsGetProcessor : public TAppCommonProcessor<TLandingsGetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLandingsGetProcessor, TEmptyConfig>;
public:
    TLandingsGetProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "landings_get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLandingRemoveProcessor : public TAppCommonProcessor<TLandingRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLandingRemoveProcessor, TEmptyConfig>;
public:
    TLandingRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "landing_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLandingProposeProcessor: public TObjectsProposeProcessor<TLanding, TLandingProposeProcessor> {
private:
    using TBase = TObjectsProposeProcessor<TLanding, TLandingProposeProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TLanding>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetDriveAPI()->GetLandingsDB();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Landings;
    }
public:
    using TBase::TBase;
};

class TLandingConfirmProcessor: public TObjectsConfirmProcessor<TLanding, TLandingConfirmProcessor> {
private:
    using TBase = TObjectsConfirmProcessor<TLanding, TLandingConfirmProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TLanding>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetDriveAPI()->GetLandingsDB();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Landings;
    }
public:
    using TBase::TBase;
};

class TLandingRejectPropositionProcessor: public TObjectsRejectProcessor<TLanding, TLandingRejectPropositionProcessor> {
private:
    using TBase = TObjectsRejectProcessor<TLanding, TLandingRejectPropositionProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TLanding>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetDriveAPI()->GetLandingsDB();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Landings;
    }
public:
    using TBase::TBase;
};
