#pragma once

#include <drive/backend/cars/car_model.h>
#include <drive/backend/processors/common_app/processor.h>

#include <rtline/library/json/field.h>
#include <rtline/util/types/field.h>
#include <rtline/util/types/uuid.h>

namespace NDrivematics {
    class TAddLeasingCarsProcessor : public TAppCommonProcessor<TAddLeasingCarsProcessor, TEmptyConfig> {
    private:
        using TBase = TAppCommonProcessor<TAddLeasingCarsProcessor, TEmptyConfig>;

    public:
        using TBase::TBase;

        static TString GetTypeName() {
            return "add_leasing_cars";
        }

        static TDriveModelData GenerateModelData(TStringBuf registryManufacturer, TStringBuf registryModel);
        static void CreateModel(
            TStringBuf vin,
            TStringBuf manufacturer,
            TStringBuf model,
            TMap<std::pair<TString, TString>, TString>& mapping,
            const TDriveAPI& driveApi, NDrive::TEntitySession& session
        );

    private:
        virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TCarInfo {
    public:
        R_FIELD(TString, VIN);
        R_FIELD(TString, TaxiCompanyName);
        R_FIELD(ui64, TaxiCompanyTin, 0);
        R_FIELD(TString, LeasingCompanyName);
        R_FIELD(TString, Number);
        R_FIELD(TString, Manufacturer);
        R_FIELD(TString, Model);
        R_FIELD(TString, City);
        R_OPTIONAL(TString, BrandId);
        R_OPTIONAL(TString, BrandName);
        R_FIELD(bool, HasTelematics, false);

    public:
        DECLARE_FIELDS(
            Field(VIN, "vin"),
            Field(TaxiCompanyName, "taxi_company"),
            Field(TaxiCompanyTin, "taxi_company_tin"),
            Field(LeasingCompanyName, "leasing_company"),
            Field(Number, "number"),
            Field(Manufacturer, "manufacturer"),
            Field(Model, "model"),
            Field(City, "city"),
            Field(BrandId, "brand_id"),
            Field(BrandName, "brand_name"),
            Field(HasTelematics, "has_telematics")
        );
    };
}
