#pragma once

#include <drive/backend/processors/common_app/processor.h>

namespace NDrivematics {
    enum class EHistoryScoreType {
        Average /* "average" */,
        Median /* "median" */
    };
}

namespace NDrivematics {
    class TCalcTaxiCompanyStatsProcessor : public TAppCommonProcessor<TCalcTaxiCompanyStatsProcessor> {
    private:
        using TBase = TAppCommonProcessor<TCalcTaxiCompanyStatsProcessor>;

    public:
        using TBase::TBase;

        static TString GetTypeName() {
            return "calc_taxi_company_stats";
        }

    private:
        virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TFleetScoringStatsProcessor : public TAppCommonProcessor<TFleetScoringStatsProcessor> {
    private:
        using TBase = TAppCommonProcessor<TFleetScoringStatsProcessor>;

    public:
        using TBase::TBase;

        static TString GetTypeName() {
            return "fleet_scoring_stats";
        }

    private:
        virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

}
