#include "delete_user.h"

#include "common.h"

namespace NDrivematics {
    void TDMUserForceDeletionProcessor::DoCheckDeletePermissions(const TString& userId, TUserPermissions::TPtr permissions) const {
        auto tx = BuildTx<NSQL::ReadOnly>();
        CheckAccessToOrganizationMember(userId, permissions, *Yensured(Server), tx);
    }
}
